## API Review Notes for August 30th, 2020

### Changes Reviewed
Starting commit: `b9a1d7405e21f71d280fdef8b63ddd2276d5a7b7`

Ending commit: `e0437f4126702fe1f53c6c3360646b0769def695`

### Notes

#### Should `SkipAnalyzers` also skip diagnostic suppressors?

We've added a command line switch to allow users to skip analyzers when running the compiler. This is mainly for perf, allowing customers to do the same things that we've been doing in the Roslyn build without resorting to msbuild trickery around removing analyzers before a build occurs. It also works with source generators, which are fed through the same property. However, a concern was raised that suppressors won't run in this scenario, which could break some builds. While this is a real concern, there's a counterpoint that running suppressors basically invalidates all the perf benefits that would be gained by having this flag in the first place. More discussion on this is needed.

#### `GeneratedSourceResult.HintName` might not be descriptive enough

The `HintName` property on `GeneratedSourceResult` is not very descriptive, and doesn't indicate anything about the desired stability of the property. We should rename to something that indicates that it should remain stable (or at least deterministic).

#### `GeneratorDriver.RunFullGeneration` seems misnamed in the face of the new apis

We now have `GeneratorDriver.RunGenerators` method. With that present, the `RunFullGeneration` API seems misnamed. If it's still necessary, then perhaps naming it something like `RunGenerationAndCreateCompilation` would be more appropriate.

#### Remove `SymbolDisplayMiscellaneousOptions.UseExplicitManagedCallingConventionSpecifier`

We're not planning on using this in the IDE currently. This can be removed until we get a request for the API.

#### `SyntaxTreeOptionsProvider.IsGenerated` should use an enum, not a try-state

Rather than a nullable bool, which isn't very descriptive of what `null` means, this should use a named enum for clarity.

#### `SyntaxTreeOptionsProvider` methods should take `CancellationTokens`

We expect that it is reasonable for implementations of this class to do computation on method calls, to allow the IDE to be lazy. Therefore these should take `CancellationToken`s to allow the IDE to cancel work if necessary.

#### `IMethodSymbol.CallingConventionTypes`

This should be renamed to `UnmangedCallingConventionTypes` to fit in with the syntax.
